/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetObjectRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private String ifMatch;
    private String ifNoneMatch;
    private String opcClientRequestId;
    private Range range;

    @ConstructorProperties(value={"namespaceName", "bucketName", "objectName", "ifMatch", "ifNoneMatch", "opcClientRequestId", "range"})
    GetObjectRequest(String namespaceName, String bucketName, String objectName, String ifMatch, String ifNoneMatch, String opcClientRequestId, Range range) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.ifMatch = ifMatch;
        this.ifNoneMatch = ifNoneMatch;
        this.opcClientRequestId = opcClientRequestId;
        this.range = range;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private String objectName;
        private String ifMatch;
        private String ifNoneMatch;
        private String opcClientRequestId;
        private Range range;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.ifMatch(o.getIfMatch());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.range(o.getRange());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetObjectRequest build() {
            GetObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public GetObjectRequest buildWithoutInvocationCallback() {
            return new GetObjectRequest(this.namespaceName, this.bucketName, this.objectName, this.ifMatch, this.ifNoneMatch, this.opcClientRequestId, this.range);
        }

        public String toString() {
            return "GetObjectRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", ifMatch=" + this.ifMatch + ", ifNoneMatch=" + this.ifNoneMatch + ", opcClientRequestId=" + this.opcClientRequestId + ", range=" + this.range + ")";
        }
    }
}

