/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPreauthenticatedRequestRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private String parId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "parId", "opcClientRequestId"})
    GetPreauthenticatedRequestRequest(String namespaceName, String bucketName, String parId, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.parId = parId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getParId() {
        return this.parId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private String parId;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPreauthenticatedRequestRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.parId(o.getParId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPreauthenticatedRequestRequest build() {
            GetPreauthenticatedRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder parId(String parId) {
            this.parId = parId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public GetPreauthenticatedRequestRequest buildWithoutInvocationCallback() {
            return new GetPreauthenticatedRequestRequest(this.namespaceName, this.bucketName, this.parId, this.opcClientRequestId);
        }

        public String toString() {
            return "GetPreauthenticatedRequestRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", parId=" + this.parId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

