/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestLogsRequest
extends BmcRequest {
    private String workRequestId;
    private String page;
    private Integer limit;
    private String opcClientRequestId;

    @ConstructorProperties(value={"workRequestId", "page", "limit", "opcClientRequestId"})
    ListWorkRequestLogsRequest(String workRequestId, String page, Integer limit, String opcClientRequestId) {
        this.workRequestId = workRequestId;
        this.page = page;
        this.limit = limit;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String workRequestId;
        private String page;
        private Integer limit;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestLogsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestLogsRequest build() {
            ListWorkRequestLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public ListWorkRequestLogsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestLogsRequest(this.workRequestId, this.page, this.limit, this.opcClientRequestId);
        }

        public String toString() {
            return "ListWorkRequestLogsRequest.Builder(workRequestId=" + this.workRequestId + ", page=" + this.page + ", limit=" + this.limit + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

