/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.objectstorage.model.RestoreObjectsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RestoreObjectsRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private RestoreObjectsDetails restoreObjectsDetails;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "restoreObjectsDetails", "opcClientRequestId"})
    RestoreObjectsRequest(String namespaceName, String bucketName, RestoreObjectsDetails restoreObjectsDetails, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.restoreObjectsDetails = restoreObjectsDetails;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public RestoreObjectsDetails getRestoreObjectsDetails() {
        return this.restoreObjectsDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private RestoreObjectsDetails restoreObjectsDetails;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreObjectsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.restoreObjectsDetails(o.getRestoreObjectsDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreObjectsRequest build() {
            RestoreObjectsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder restoreObjectsDetails(RestoreObjectsDetails restoreObjectsDetails) {
            this.restoreObjectsDetails = restoreObjectsDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public RestoreObjectsRequest buildWithoutInvocationCallback() {
            return new RestoreObjectsRequest(this.namespaceName, this.bucketName, this.restoreObjectsDetails, this.opcClientRequestId);
        }

        public String toString() {
            return "RestoreObjectsRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", restoreObjectsDetails=" + this.restoreObjectsDetails + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

