/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class CancelWorkRequestResponse {
    private String opcRequestId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"opcRequestId", "opcClientRequestId"})
    CancelWorkRequestResponse(String opcRequestId, String opcClientRequestId) {
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcClientRequestId;

        public Builder copy(CancelWorkRequestResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public CancelWorkRequestResponse build() {
            return new CancelWorkRequestResponse(this.opcRequestId, this.opcClientRequestId);
        }

        public String toString() {
            return "CancelWorkRequestResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

