/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;
import java.util.Date;

public class CommitMultipartUploadResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcMultipartMd5;
    private String eTag;
    private Date lastModified;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "opcMultipartMd5", "eTag", "lastModified"})
    CommitMultipartUploadResponse(String opcClientRequestId, String opcRequestId, String opcMultipartMd5, String eTag, Date lastModified) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcMultipartMd5 = opcMultipartMd5;
        this.eTag = eTag;
        this.lastModified = lastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcMultipartMd5() {
        return this.opcMultipartMd5;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcMultipartMd5;
        private String eTag;
        private Date lastModified;

        public Builder copy(CommitMultipartUploadResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcMultipartMd5(o.getOpcMultipartMd5());
            this.eTag(o.getETag());
            this.lastModified(o.getLastModified());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcMultipartMd5(String opcMultipartMd5) {
            this.opcMultipartMd5 = opcMultipartMd5;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public CommitMultipartUploadResponse build() {
            return new CommitMultipartUploadResponse(this.opcClientRequestId, this.opcRequestId, this.opcMultipartMd5, this.eTag, this.lastModified);
        }

        public String toString() {
            return "CommitMultipartUploadResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", opcMultipartMd5=" + this.opcMultipartMd5 + ", eTag=" + this.eTag + ", lastModified=" + this.lastModified + ")";
        }
    }
}

