/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class CopyObjectResponse {
    private String opcWorkRequestId;
    private String opcRequestId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"opcWorkRequestId", "opcRequestId", "opcClientRequestId"})
    CopyObjectResponse(String opcWorkRequestId, String opcRequestId, String opcClientRequestId) {
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String opcWorkRequestId;
        private String opcRequestId;
        private String opcClientRequestId;

        public Builder copy(CopyObjectResponse o) {
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            return this;
        }

        Builder() {
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public CopyObjectResponse build() {
            return new CopyObjectResponse(this.opcWorkRequestId, this.opcRequestId, this.opcClientRequestId);
        }

        public String toString() {
            return "CopyObjectResponse.Builder(opcWorkRequestId=" + this.opcWorkRequestId + ", opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

