/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class DeleteBucketResponse {
    private String opcClientRequestId;
    private String opcRequestId;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId"})
    DeleteBucketResponse(String opcClientRequestId, String opcRequestId) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;

        public Builder copy(DeleteBucketResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteBucketResponse build() {
            return new DeleteBucketResponse(this.opcClientRequestId, this.opcRequestId);
        }

        public String toString() {
            return "DeleteBucketResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

