/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;
import java.util.Date;

public class DeleteObjectResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private Date lastModified;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "lastModified"})
    DeleteObjectResponse(String opcClientRequestId, String opcRequestId, Date lastModified) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.lastModified = lastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private Date lastModified;

        public Builder copy(DeleteObjectResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.lastModified(o.getLastModified());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public DeleteObjectResponse build() {
            return new DeleteObjectResponse(this.opcClientRequestId, this.opcRequestId, this.lastModified);
        }

        public String toString() {
            return "DeleteObjectResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", lastModified=" + this.lastModified + ")";
        }
    }
}

