/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.Bucket;
import java.beans.ConstructorProperties;

public class GetBucketResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private Bucket bucket;
    private boolean isNotModified;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "eTag", "bucket", "isNotModified"})
    GetBucketResponse(String opcClientRequestId, String opcRequestId, String eTag, Bucket bucket, boolean isNotModified) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.bucket = bucket;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private Bucket bucket;
        private boolean isNotModified;

        public Builder copy(GetBucketResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.bucket(o.getBucket());
            this.isNotModified(o.isNotModified());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder bucket(Bucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public GetBucketResponse build() {
            return new GetBucketResponse(this.opcClientRequestId, this.opcRequestId, this.eTag, this.bucket, this.isNotModified);
        }

        public String toString() {
            return "GetBucketResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", bucket=" + this.bucket + ", isNotModified=" + this.isNotModified + ")";
        }
    }
}

