/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.NamespaceMetadata;
import java.beans.ConstructorProperties;

public class GetNamespaceMetadataResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private NamespaceMetadata namespaceMetadata;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "namespaceMetadata"})
    GetNamespaceMetadataResponse(String opcClientRequestId, String opcRequestId, NamespaceMetadata namespaceMetadata) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.namespaceMetadata = namespaceMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NamespaceMetadata getNamespaceMetadata() {
        return this.namespaceMetadata;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private NamespaceMetadata namespaceMetadata;

        public Builder copy(GetNamespaceMetadataResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.namespaceMetadata(o.getNamespaceMetadata());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder namespaceMetadata(NamespaceMetadata namespaceMetadata) {
            this.namespaceMetadata = namespaceMetadata;
            return this;
        }

        public GetNamespaceMetadataResponse build() {
            return new GetNamespaceMetadataResponse(this.opcClientRequestId, this.opcRequestId, this.namespaceMetadata);
        }

        public String toString() {
            return "GetNamespaceMetadataResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", namespaceMetadata=" + this.namespaceMetadata + ")";
        }
    }
}

