/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.WorkRequest;
import java.beans.ConstructorProperties;

public class GetWorkRequestResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private Float retryAfter;
    private WorkRequest workRequest;

    @ConstructorProperties(value={"opcRequestId", "opcClientRequestId", "retryAfter", "workRequest"})
    GetWorkRequestResponse(String opcRequestId, String opcClientRequestId, Float retryAfter, WorkRequest workRequest) {
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.retryAfter = retryAfter;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcClientRequestId;
        private Float retryAfter;
        private WorkRequest workRequest;

        public Builder copy(GetWorkRequestResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.retryAfter(o.getRetryAfter());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.opcRequestId, this.opcClientRequestId, this.retryAfter, this.workRequest);
        }

        public String toString() {
            return "GetWorkRequestResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ", retryAfter=" + this.retryAfter + ", workRequest=" + this.workRequest + ")";
        }
    }
}

