/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ListObjects;
import java.beans.ConstructorProperties;

public class ListObjectsResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private ListObjects listObjects;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "listObjects"})
    ListObjectsResponse(String opcClientRequestId, String opcRequestId, ListObjects listObjects) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.listObjects = listObjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ListObjects getListObjects() {
        return this.listObjects;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private ListObjects listObjects;

        public Builder copy(ListObjectsResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.listObjects(o.getListObjects());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder listObjects(ListObjects listObjects) {
            this.listObjects = listObjects;
            return this;
        }

        public ListObjectsResponse build() {
            return new ListObjectsResponse(this.opcClientRequestId, this.opcRequestId, this.listObjects);
        }

        public String toString() {
            return "ListObjectsResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", listObjects=" + this.listObjects + ")";
        }
    }
}

