/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.WorkRequestError;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestErrorsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcClientRequestId;
    private List<WorkRequestError> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "opcClientRequestId", "items"})
    ListWorkRequestErrorsResponse(String opcRequestId, String opcNextPage, String opcClientRequestId, List<WorkRequestError> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcClientRequestId = opcClientRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public List<WorkRequestError> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private String opcClientRequestId;
        private List<WorkRequestError> items;

        public Builder copy(ListWorkRequestErrorsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder items(List<WorkRequestError> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestErrorsResponse build() {
            return new ListWorkRequestErrorsResponse(this.opcRequestId, this.opcNextPage, this.opcClientRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestErrorsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", opcClientRequestId=" + this.opcClientRequestId + ", items=" + this.items + ")";
        }
    }
}

