/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;
import java.util.Date;

public class PutObjectResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcContentMd5;
    private String eTag;
    private Date lastModified;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "opcContentMd5", "eTag", "lastModified"})
    PutObjectResponse(String opcClientRequestId, String opcRequestId, String opcContentMd5, String eTag, Date lastModified) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcContentMd5 = opcContentMd5;
        this.eTag = eTag;
        this.lastModified = lastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcContentMd5() {
        return this.opcContentMd5;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcContentMd5;
        private String eTag;
        private Date lastModified;

        public Builder copy(PutObjectResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcContentMd5(o.getOpcContentMd5());
            this.eTag(o.getETag());
            this.lastModified(o.getLastModified());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcContentMd5(String opcContentMd5) {
            this.opcContentMd5 = opcContentMd5;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public PutObjectResponse build() {
            return new PutObjectResponse(this.opcClientRequestId, this.opcRequestId, this.opcContentMd5, this.eTag, this.lastModified);
        }

        public String toString() {
            return "PutObjectResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", opcContentMd5=" + this.opcContentMd5 + ", eTag=" + this.eTag + ", lastModified=" + this.lastModified + ")";
        }
    }
}

