/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import java.beans.ConstructorProperties;

public class ReencryptBucketResponse {
    private String opcWorkRequestId;
    private String opcClientRequestId;
    private String opcRequestId;

    @ConstructorProperties(value={"opcWorkRequestId", "opcClientRequestId", "opcRequestId"})
    ReencryptBucketResponse(String opcWorkRequestId, String opcClientRequestId, String opcRequestId) {
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String opcWorkRequestId;
        private String opcClientRequestId;
        private String opcRequestId;

        public Builder copy(ReencryptBucketResponse o) {
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            return this;
        }

        Builder() {
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ReencryptBucketResponse build() {
            return new ReencryptBucketResponse(this.opcWorkRequestId, this.opcClientRequestId, this.opcRequestId);
        }

        public String toString() {
            return "ReencryptBucketResponse.Builder(opcWorkRequestId=" + this.opcWorkRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

