/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.Bucket;
import java.beans.ConstructorProperties;

public class UpdateBucketResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private Bucket bucket;

    @ConstructorProperties(value={"opcClientRequestId", "opcRequestId", "eTag", "bucket"})
    UpdateBucketResponse(String opcClientRequestId, String opcRequestId, String eTag, Bucket bucket) {
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.bucket = bucket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private Bucket bucket;

        public Builder copy(UpdateBucketResponse o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.bucket(o.getBucket());
            return this;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder bucket(Bucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public UpdateBucketResponse build() {
            return new UpdateBucketResponse(this.opcClientRequestId, this.opcRequestId, this.eTag, this.bucket);
        }

        public String toString() {
            return "UpdateBucketResponse.Builder(opcClientRequestId=" + this.opcClientRequestId + ", opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", bucket=" + this.bucket + ")";
        }
    }
}

