/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.objectstorage.transfer.ProgressReporter;
import java.beans.ConstructorProperties;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;

@NotThreadSafe
class ProgressTracker {
    @NonNull
    private final ProgressReporter progressReporter;
    private final long totalBytes;
    private long totalBytesRead = 0L;

    void onBytesRead(long bytesRead) {
        this.totalBytesRead += bytesRead;
        if (this.totalBytesRead < 0L || this.totalBytesRead > this.totalBytes) {
            throw new IllegalStateException(String.format("IllegalState - bytes read %d causes total bytes read(%d)/total bytes(%d)", bytesRead, this.totalBytesRead, this.totalBytes));
        }
        this.progressReporter.onProgress(this.totalBytesRead, this.totalBytes);
    }

    ProgressTracker reset() {
        this.totalBytesRead = 0L;
        return this;
    }

    protected void invalidateBytesRead(long invalidByteCount) {
        if (invalidByteCount > this.totalBytesRead) {
            throw new IllegalStateException(String.format("Cannot invalidate %d bytes when total read bytes is %d", invalidByteCount, this.totalBytesRead));
        }
        this.totalBytesRead -= invalidByteCount;
    }

    @ConstructorProperties(value={"progressReporter", "totalBytes"})
    ProgressTracker(@NonNull ProgressReporter progressReporter, long totalBytes) {
        if (progressReporter == null) {
            throw new NullPointerException("progressReporter is marked @NonNull but is null");
        }
        this.progressReporter = progressReporter;
        this.totalBytes = totalBytes;
    }

    protected long getTotalBytesRead() {
        return this.totalBytesRead;
    }
}

