/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.objectstorage.transfer.ProgressReporter;
import com.oracle.bmc.objectstorage.transfer.ProgressTracker;
import javax.annotation.concurrent.ThreadSafe;

abstract class ProgressTrackerFactory {
    private static final ProgressTrackerFactory DUMMY_PROGRESS_TRACKER_FACTORY = new ProgressTrackerFactory(){

        @Override
        ProgressTracker getProgressTracker() {
            return null;
        }
    };

    ProgressTrackerFactory() {
    }

    static ProgressTrackerFactory createSingleUploadProgressTrackerFactory(ProgressReporter progressReporter, long totalBytes) {
        if (progressReporter == null) {
            return DUMMY_PROGRESS_TRACKER_FACTORY;
        }
        return new SingleUploadProgressTrackerFactory(progressReporter, totalBytes);
    }

    static ProgressTrackerFactory createMultiPartUploadProgressTrackerFactory(ProgressReporter progressReporter, long totalBytes) {
        if (progressReporter == null) {
            return DUMMY_PROGRESS_TRACKER_FACTORY;
        }
        return new MultiPartUploadProgressTrackerFactory(progressReporter, totalBytes);
    }

    abstract ProgressTracker getProgressTracker();

    private static class MultiPartUploadProgressTrackerFactory
    extends ProgressTrackerFactory {
        private static final ProgressReporter DUMMY_PROGRESS_REPORTER = new ProgressReporter(){

            @Override
            public void onProgress(long completed, long total) {
            }
        };
        private final ProgressTracker rootProgressTracker;

        private MultiPartUploadProgressTrackerFactory(ProgressReporter progressReporter, long totalBytes) {
            this.rootProgressTracker = new ProgressTracker(progressReporter, totalBytes);
        }

        @Override
        ProgressTracker getProgressTracker() {
            return new SubProgressTracker();
        }

        @ThreadSafe
        private class SubProgressTracker
        extends ProgressTracker {
            private SubProgressTracker() {
                super(DUMMY_PROGRESS_REPORTER, Long.MAX_VALUE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onBytesRead(long bytesRead) {
                super.onBytesRead(bytesRead);
                ProgressTracker progressTracker = MultiPartUploadProgressTrackerFactory.this.rootProgressTracker;
                synchronized (progressTracker) {
                    MultiPartUploadProgressTrackerFactory.this.rootProgressTracker.onBytesRead(bytesRead);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            ProgressTracker reset() {
                ProgressTracker progressTracker = MultiPartUploadProgressTrackerFactory.this.rootProgressTracker;
                synchronized (progressTracker) {
                    MultiPartUploadProgressTrackerFactory.this.rootProgressTracker.invalidateBytesRead(this.getTotalBytesRead());
                }
                return super.reset();
            }
        }
    }

    private static class SingleUploadProgressTrackerFactory
    extends ProgressTrackerFactory {
        private final ProgressTracker progressTracker;

        private SingleUploadProgressTrackerFactory(ProgressReporter progressReporter, long totalBytes) {
            this.progressTracker = new ProgressTracker(progressReporter, totalBytes);
        }

        @Override
        ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }
    }
}

