/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.google.common.base.Function;
import com.oracle.bmc.io.DuplicatableInputStream;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRetry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRetry.class);
    private static final int MAX_RETRIES = 3;
    private final ObjectStorage service;

    public Function<PutObjectRequest, PutObjectResponse> createPutObjectFunction() {
        return new Function<PutObjectRequest, PutObjectResponse>(){

            public PutObjectResponse apply(PutObjectRequest request) {
                InputStream stream = request.getPutObjectBody();
                BmcException ex = null;
                for (int i = 1; i <= 3; ++i) {
                    try {
                        return SimpleRetry.this.service.putObject(request);
                    }
                    catch (BmcException e) {
                        LOG.warn("PutObject failed on attempt " + i, (Throwable)e);
                        ex = e;
                        if (!SimpleRetry.canRetry(stream, e, i)) break;
                        LOG.info("Retrying upload");
                        request = PutObjectRequest.builder().copy(request).putObjectBody(((DuplicatableInputStream)((Object)stream)).duplicate()).build();
                        continue;
                    }
                }
                throw ex;
            }
        };
    }

    public Function<UploadPartRequest, UploadPartResponse> createUploadPartFunction() {
        return new Function<UploadPartRequest, UploadPartResponse>(){

            public UploadPartResponse apply(UploadPartRequest request) {
                InputStream stream = request.getUploadPartBody();
                BmcException ex = null;
                for (int i = 1; i <= 3; ++i) {
                    try {
                        return SimpleRetry.this.service.uploadPart(request);
                    }
                    catch (BmcException e) {
                        LOG.warn("UploadPart for part " + request.getUploadPartNum() + " failed on attempt " + i, (Throwable)e);
                        ex = e;
                        if (!SimpleRetry.canRetry(stream, e, i)) break;
                        LOG.info("Retrying upload of part " + request.getUploadPartNum());
                        request = UploadPartRequest.builder().copy(request).uploadPartBody(((DuplicatableInputStream)((Object)stream)).duplicate()).build();
                        continue;
                    }
                }
                throw ex;
            }
        };
    }

    private static boolean canRetry(InputStream stream, BmcException e, int currentAttempt) {
        boolean isDuplicatable = stream instanceof DuplicatableInputStream;
        boolean hasMoreAttempts = currentAttempt < 3;
        boolean isExceptionRetryable = e.isTimeout() || e.getStatusCode() == -1 || e.getStatusCode() >= 500 || e.getStatusCode() == 409 && "ConcurrentObjectUpdate".equals(e.getServiceCode());
        return isDuplicatable && hasMoreAttempts && isExceptionRetryable;
    }

    @ConstructorProperties(value={"service"})
    public SimpleRetry(ObjectStorage service) {
        this.service = service;
    }
}

