/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.oce.OceInstance;
import com.oracle.bmc.oce.model.OceInstanceSummary;
import com.oracle.bmc.oce.model.WorkRequest;
import com.oracle.bmc.oce.model.WorkRequestError;
import com.oracle.bmc.oce.model.WorkRequestLogEntry;
import com.oracle.bmc.oce.requests.ListOceInstancesRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oce.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oce.responses.ListOceInstancesResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oce.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class OceInstancePaginators {
    private final OceInstance client;

    public Iterable<ListOceInstancesResponse> listOceInstancesResponseIterator(final ListOceInstancesRequest request) {
        return new ResponseIterable<ListOceInstancesRequest.Builder, ListOceInstancesRequest, ListOceInstancesResponse>(new Supplier<ListOceInstancesRequest.Builder>(){

            public ListOceInstancesRequest.Builder get() {
                return ListOceInstancesRequest.builder().copy(request);
            }
        }, new Function<ListOceInstancesResponse, String>(){

            public String apply(ListOceInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListOceInstancesRequest.Builder>, ListOceInstancesRequest>(){

            public ListOceInstancesRequest apply(RequestBuilderAndToken<ListOceInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListOceInstancesRequest, ListOceInstancesResponse>(){

            public ListOceInstancesResponse apply(ListOceInstancesRequest request) {
                return OceInstancePaginators.this.client.listOceInstances(request);
            }
        });
    }

    public Iterable<OceInstanceSummary> listOceInstancesRecordIterator(final ListOceInstancesRequest request) {
        return new ResponseRecordIterable<ListOceInstancesRequest.Builder, ListOceInstancesRequest, ListOceInstancesResponse, OceInstanceSummary>(new Supplier<ListOceInstancesRequest.Builder>(){

            public ListOceInstancesRequest.Builder get() {
                return ListOceInstancesRequest.builder().copy(request);
            }
        }, new Function<ListOceInstancesResponse, String>(){

            public String apply(ListOceInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListOceInstancesRequest.Builder>, ListOceInstancesRequest>(){

            public ListOceInstancesRequest apply(RequestBuilderAndToken<ListOceInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListOceInstancesRequest, ListOceInstancesResponse>(){

            public ListOceInstancesResponse apply(ListOceInstancesRequest request) {
                return OceInstancePaginators.this.client.listOceInstances(request);
            }
        }, new Function<ListOceInstancesResponse, List<OceInstanceSummary>>(){

            public List<OceInstanceSummary> apply(ListOceInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse, WorkRequestError>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse, WorkRequestLogEntry>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        }, new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequest>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OceInstancePaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public OceInstancePaginators(OceInstance client) {
        this.client = client;
    }
}

