/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.oce.OceInstance;
import com.oracle.bmc.oce.model.OceInstance;
import com.oracle.bmc.oce.requests.GetOceInstanceRequest;
import com.oracle.bmc.oce.requests.GetWorkRequestRequest;
import com.oracle.bmc.oce.responses.GetOceInstanceResponse;
import com.oracle.bmc.oce.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class OceInstanceWaiters {
    private final ExecutorService executorService;
    private final OceInstance client;

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, OceInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, OceInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(GetOceInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OceInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOceInstance(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetOceInstanceRequest, GetOceInstanceResponse> forOceInstance(BmcGenericWaiter waiter, GetOceInstanceRequest request, OceInstance.LifecycleState ... targetStates) {
        final HashSet<OceInstance.LifecycleState> targetStatesSet = new HashSet<OceInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetOceInstanceRequest, GetOceInstanceResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetOceInstanceRequest, GetOceInstanceResponse>(){

            public GetOceInstanceResponse apply(GetOceInstanceRequest request) {
                return OceInstanceWaiters.this.client.getOceInstance(request);
            }
        }, new Predicate<GetOceInstanceResponse>(){

            public boolean apply(GetOceInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getOceInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OceInstance.LifecycleState.Deleted)), request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter(terminationStrategy, delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl<GetWorkRequestRequest, GetWorkRequestResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OceInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public OceInstanceWaiters(ExecutorService executorService, OceInstance client) {
        this.executorService = executorService;
        this.client = client;
    }
}

