/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.requests;

import com.oracle.bmc.oce.model.UpdateOceInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateOceInstanceRequest
extends BmcRequest {
    private String oceInstanceId;
    private UpdateOceInstanceDetails updateOceInstanceDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"oceInstanceId", "updateOceInstanceDetails", "ifMatch", "opcRequestId"})
    UpdateOceInstanceRequest(String oceInstanceId, UpdateOceInstanceDetails updateOceInstanceDetails, String ifMatch, String opcRequestId) {
        this.oceInstanceId = oceInstanceId;
        this.updateOceInstanceDetails = updateOceInstanceDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOceInstanceId() {
        return this.oceInstanceId;
    }

    public UpdateOceInstanceDetails getUpdateOceInstanceDetails() {
        return this.updateOceInstanceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String oceInstanceId;
        private UpdateOceInstanceDetails updateOceInstanceDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateOceInstanceRequest o) {
            this.oceInstanceId(o.getOceInstanceId());
            this.updateOceInstanceDetails(o.getUpdateOceInstanceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateOceInstanceRequest build() {
            UpdateOceInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder oceInstanceId(String oceInstanceId) {
            this.oceInstanceId = oceInstanceId;
            return this;
        }

        public Builder updateOceInstanceDetails(UpdateOceInstanceDetails updateOceInstanceDetails) {
            this.updateOceInstanceDetails = updateOceInstanceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateOceInstanceRequest buildWithoutInvocationCallback() {
            return new UpdateOceInstanceRequest(this.oceInstanceId, this.updateOceInstanceDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateOceInstanceRequest.Builder(oceInstanceId=" + this.oceInstanceId + ", updateOceInstanceDetails=" + this.updateOceInstanceDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

