/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.oda.OdaAsync;
import com.oracle.bmc.oda.internal.http.ChangeOdaInstanceCompartmentConverter;
import com.oracle.bmc.oda.internal.http.CreateOdaInstanceConverter;
import com.oracle.bmc.oda.internal.http.DeleteOdaInstanceConverter;
import com.oracle.bmc.oda.internal.http.GetOdaInstanceConverter;
import com.oracle.bmc.oda.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.oda.internal.http.ListOdaInstancesConverter;
import com.oracle.bmc.oda.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.oda.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.oda.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.oda.internal.http.UpdateOdaInstanceConverter;
import com.oracle.bmc.oda.requests.ChangeOdaInstanceCompartmentRequest;
import com.oracle.bmc.oda.requests.CreateOdaInstanceRequest;
import com.oracle.bmc.oda.requests.DeleteOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetWorkRequestRequest;
import com.oracle.bmc.oda.requests.ListOdaInstancesRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oda.requests.UpdateOdaInstanceRequest;
import com.oracle.bmc.oda.responses.ChangeOdaInstanceCompartmentResponse;
import com.oracle.bmc.oda.responses.CreateOdaInstanceResponse;
import com.oracle.bmc.oda.responses.DeleteOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetWorkRequestResponse;
import com.oracle.bmc.oda.responses.ListOdaInstancesResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestsResponse;
import com.oracle.bmc.oda.responses.UpdateOdaInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdaAsyncClient
implements OdaAsync {
    private static final Logger LOG = LoggerFactory.getLogger(OdaAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ODA").serviceEndpointPrefix("").serviceEndpointTemplate("https://digitalassistant-api.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OdaAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OdaAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeOdaInstanceCompartmentResponse> changeOdaInstanceCompartment(ChangeOdaInstanceCompartmentRequest request, AsyncHandler<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse> handler) {
        LOG.trace("Called async changeOdaInstanceCompartment");
        final ChangeOdaInstanceCompartmentRequest interceptedRequest = ChangeOdaInstanceCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeOdaInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeOdaInstanceCompartmentResponse> transformer = ChangeOdaInstanceCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse> onSuccess = new SuccessConsumer<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeOdaInstanceCompartmentRequest> onError = new ErrorConsumer<ChangeOdaInstanceCompartmentRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.post(ib, interceptedRequest.getChangeOdaInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeOdaInstanceCompartmentRequest, ChangeOdaInstanceCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeOdaInstanceCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeOdaInstanceCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeOdaInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeOdaInstanceCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.post(ib, interceptedRequest.getChangeOdaInstanceCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeOdaInstanceCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateOdaInstanceResponse> createOdaInstance(CreateOdaInstanceRequest request, AsyncHandler<CreateOdaInstanceRequest, CreateOdaInstanceResponse> handler) {
        LOG.trace("Called async createOdaInstance");
        final CreateOdaInstanceRequest interceptedRequest = CreateOdaInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateOdaInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateOdaInstanceResponse> transformer = CreateOdaInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateOdaInstanceRequest, CreateOdaInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateOdaInstanceRequest, CreateOdaInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateOdaInstanceRequest, CreateOdaInstanceResponse> onSuccess = new SuccessConsumer<CreateOdaInstanceRequest, CreateOdaInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateOdaInstanceRequest> onError = new ErrorConsumer<CreateOdaInstanceRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.post(ib, interceptedRequest.getCreateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateOdaInstanceRequest, CreateOdaInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateOdaInstanceRequest, CreateOdaInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateOdaInstanceRequest> onError = handler == null ? null : new ErrorConsumer<CreateOdaInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateOdaInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.post(ib, interceptedRequest.getCreateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateOdaInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteOdaInstanceResponse> deleteOdaInstance(DeleteOdaInstanceRequest request, AsyncHandler<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse> handler) {
        LOG.trace("Called async deleteOdaInstance");
        final DeleteOdaInstanceRequest interceptedRequest = DeleteOdaInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteOdaInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteOdaInstanceResponse> transformer = DeleteOdaInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse> onSuccess = new SuccessConsumer<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteOdaInstanceRequest> onError = new ErrorConsumer<DeleteOdaInstanceRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteOdaInstanceRequest, DeleteOdaInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteOdaInstanceRequest> onError = handler == null ? null : new ErrorConsumer<DeleteOdaInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteOdaInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteOdaInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetOdaInstanceResponse> getOdaInstance(GetOdaInstanceRequest request, AsyncHandler<GetOdaInstanceRequest, GetOdaInstanceResponse> handler) {
        LOG.trace("Called async getOdaInstance");
        final GetOdaInstanceRequest interceptedRequest = GetOdaInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetOdaInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetOdaInstanceResponse> transformer = GetOdaInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetOdaInstanceRequest, GetOdaInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetOdaInstanceRequest, GetOdaInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetOdaInstanceRequest, GetOdaInstanceResponse> onSuccess = new SuccessConsumer<GetOdaInstanceRequest, GetOdaInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetOdaInstanceRequest> onError = new ErrorConsumer<GetOdaInstanceRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetOdaInstanceRequest, GetOdaInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetOdaInstanceRequest, GetOdaInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetOdaInstanceRequest> onError = handler == null ? null : new ErrorConsumer<GetOdaInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetOdaInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetOdaInstanceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListOdaInstancesResponse> listOdaInstances(ListOdaInstancesRequest request, AsyncHandler<ListOdaInstancesRequest, ListOdaInstancesResponse> handler) {
        LOG.trace("Called async listOdaInstances");
        final ListOdaInstancesRequest interceptedRequest = ListOdaInstancesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListOdaInstancesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListOdaInstancesResponse> transformer = ListOdaInstancesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListOdaInstancesRequest, ListOdaInstancesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListOdaInstancesRequest, ListOdaInstancesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListOdaInstancesRequest, ListOdaInstancesResponse> onSuccess = new SuccessConsumer<ListOdaInstancesRequest, ListOdaInstancesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListOdaInstancesRequest> onError = new ErrorConsumer<ListOdaInstancesRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListOdaInstancesRequest, ListOdaInstancesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListOdaInstancesRequest, ListOdaInstancesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListOdaInstancesRequest> onError = handler == null ? null : new ErrorConsumer<ListOdaInstancesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListOdaInstancesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListOdaInstancesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestErrorsRequest> onError = new ErrorConsumer<ListWorkRequestErrorsRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestErrorsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestErrorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestLogsRequest> onError = new ErrorConsumer<ListWorkRequestLogsRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateOdaInstanceResponse> updateOdaInstance(UpdateOdaInstanceRequest request, AsyncHandler<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse> handler) {
        LOG.trace("Called async updateOdaInstance");
        final UpdateOdaInstanceRequest interceptedRequest = UpdateOdaInstanceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateOdaInstanceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateOdaInstanceResponse> transformer = UpdateOdaInstanceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse> onSuccess = new SuccessConsumer<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateOdaInstanceRequest> onError = new ErrorConsumer<UpdateOdaInstanceRequest>(this, interceptedRequest);
                    OdaAsyncClient.this.client.put(ib, interceptedRequest.getUpdateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateOdaInstanceRequest, UpdateOdaInstanceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateOdaInstanceRequest> onError = handler == null ? null : new ErrorConsumer<UpdateOdaInstanceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateOdaInstanceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return OdaAsyncClient.this.client.put(ib, interceptedRequest.getUpdateOdaInstanceDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateOdaInstanceResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OdaAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public OdaAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new OdaAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

