/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.oda.model.OdaInstance;
import com.oracle.bmc.oda.requests.CreateOdaInstanceRequest;
import com.oracle.bmc.oda.responses.CreateOdaInstanceResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOdaInstanceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOdaInstanceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateOdaInstanceRequest interceptRequest(CreateOdaInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateOdaInstanceRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateOdaInstanceDetails(), (String)"createOdaInstanceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190506").path("odaInstances");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateOdaInstanceResponse> fromResponse() {
        Function<Response, CreateOdaInstanceResponse> transformer = new Function<Response, CreateOdaInstanceResponse>(){

            public CreateOdaInstanceResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                Optional<List<String>> opcWorkRequestIdHeader;
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for CreateOdaInstanceResponse");
                Function<Response, WithHeaders<OdaInstance>> responseFn = RESPONSE_CONVERSION_FACTORY.create(OdaInstance.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateOdaInstanceResponse.Builder builder = CreateOdaInstanceResponse.builder();
                builder.odaInstance((OdaInstance)response.getItem());
                Optional<List<String>> locationHeader = HeaderUtils.get(headers, "Location");
                if (locationHeader.isPresent()) {
                    builder.location(HeaderUtils.toValue("Location", (String)((List)locationHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get(headers, "opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId(HeaderUtils.toValue("opc-work-request-id", (String)((List)opcWorkRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                CreateOdaInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

