/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.oda.model.OdaInstance;
import com.oracle.bmc.oda.requests.UpdateOdaInstanceRequest;
import com.oracle.bmc.oda.responses.UpdateOdaInstanceResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOdaInstanceConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateOdaInstanceConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateOdaInstanceRequest interceptRequest(UpdateOdaInstanceRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateOdaInstanceRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOdaInstanceId(), (String)"odaInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateOdaInstanceDetails(), (String)"updateOdaInstanceDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190506").path("odaInstances").path(HttpUtils.encodePathSegment(request.getOdaInstanceId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateOdaInstanceResponse> fromResponse() {
        Function<Response, UpdateOdaInstanceResponse> transformer = new Function<Response, UpdateOdaInstanceResponse>(){

            public UpdateOdaInstanceResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for UpdateOdaInstanceResponse");
                Function<Response, WithHeaders<OdaInstance>> responseFn = RESPONSE_CONVERSION_FACTORY.create(OdaInstance.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                UpdateOdaInstanceResponse.Builder builder = UpdateOdaInstanceResponse.builder();
                builder.odaInstance((OdaInstance)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                UpdateOdaInstanceResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

