/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource {
    @JsonProperty(value="resourceAction")
    private final ResourceAction resourceAction;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusMessage")
    private final String statusMessage;
    @JsonProperty(value="resourceUri")
    private final String resourceUri;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public ResourceAction getResourceAction() {
        return this.resourceAction;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)o;
        ResourceAction this$resourceAction = this.getResourceAction();
        ResourceAction other$resourceAction = other.getResourceAction();
        if (this$resourceAction == null ? other$resourceAction != null : !((Object)((Object)this$resourceAction)).equals((Object)other$resourceAction)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$statusMessage = this.getStatusMessage();
        String other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        String this$resourceUri = this.getResourceUri();
        String other$resourceUri = other.getResourceUri();
        if (this$resourceUri == null ? other$resourceUri != null : !this$resourceUri.equals(other$resourceUri)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceAction $resourceAction = this.getResourceAction();
        result = result * 59 + ($resourceAction == null ? 43 : ((Object)((Object)$resourceAction)).hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        String $resourceUri = this.getResourceUri();
        result = result * 59 + ($resourceUri == null ? 43 : $resourceUri.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "WorkRequestResource(resourceAction=" + (Object)((Object)this.getResourceAction()) + ", resourceType=" + this.getResourceType() + ", resourceId=" + this.getResourceId() + ", status=" + (Object)((Object)this.getStatus()) + ", statusMessage=" + this.getStatusMessage() + ", resourceUri=" + this.getResourceUri() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"resourceAction", "resourceType", "resourceId", "status", "statusMessage", "resourceUri"})
    @Deprecated
    public WorkRequestResource(ResourceAction resourceAction, String resourceType, String resourceId, Status status, String statusMessage, String resourceUri) {
        this.resourceAction = resourceAction;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.status = status;
        this.statusMessage = statusMessage;
        this.resourceUri = resourceUri;
    }

    public static enum Status {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceAction {
        Create("CREATE"),
        Delete("DELETE"),
        Purge("PURGE"),
        Recover("RECOVER"),
        ChangeCompartment("CHANGE_COMPARTMENT"),
        CreateAssociation("CREATE_ASSOCIATION"),
        DeleteAssociation("DELETE_ASSOCIATION"),
        UpdateEntitlementsForCacct("UPDATE_ENTITLEMENTS_FOR_CACCT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceAction> map;

        private ResourceAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceAction.class);
            map = new HashMap<String, ResourceAction>();
            for (ResourceAction v : ResourceAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceAction")
        private ResourceAction resourceAction;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusMessage")
        private String statusMessage;
        @JsonProperty(value="resourceUri")
        private String resourceUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceAction(ResourceAction resourceAction) {
            this.resourceAction = resourceAction;
            this.__explicitlySet__.add("resourceAction");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            this.__explicitlySet__.add("statusMessage");
            return this;
        }

        public Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            this.__explicitlySet__.add("resourceUri");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource __instance__ = new WorkRequestResource(this.resourceAction, this.resourceType, this.resourceId, this.status, this.statusMessage, this.resourceUri);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource o) {
            Builder copiedBuilder = this.resourceAction(o.getResourceAction()).resourceType(o.getResourceType()).resourceId(o.getResourceId()).status(o.getStatus()).statusMessage(o.getStatusMessage()).resourceUri(o.getResourceUri());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

