/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.oda.model.UpdateOdaInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateOdaInstanceRequest
extends BmcRequest {
    private String odaInstanceId;
    private UpdateOdaInstanceDetails updateOdaInstanceDetails;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"odaInstanceId", "updateOdaInstanceDetails", "ifMatch", "opcRequestId"})
    UpdateOdaInstanceRequest(String odaInstanceId, UpdateOdaInstanceDetails updateOdaInstanceDetails, String ifMatch, String opcRequestId) {
        this.odaInstanceId = odaInstanceId;
        this.updateOdaInstanceDetails = updateOdaInstanceDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public UpdateOdaInstanceDetails getUpdateOdaInstanceDetails() {
        return this.updateOdaInstanceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String odaInstanceId;
        private UpdateOdaInstanceDetails updateOdaInstanceDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateOdaInstanceRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.updateOdaInstanceDetails(o.getUpdateOdaInstanceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateOdaInstanceRequest build() {
            UpdateOdaInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder updateOdaInstanceDetails(UpdateOdaInstanceDetails updateOdaInstanceDetails) {
            this.updateOdaInstanceDetails = updateOdaInstanceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateOdaInstanceRequest buildWithoutInvocationCallback() {
            return new UpdateOdaInstanceRequest(this.odaInstanceId, this.updateOdaInstanceDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateOdaInstanceRequest.Builder(odaInstanceId=" + this.odaInstanceId + ", updateOdaInstanceDetails=" + this.updateOdaInstanceDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

