/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.responses;

import com.oracle.bmc.oda.model.OdaInstanceSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListOdaInstancesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<OdaInstanceSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListOdaInstancesResponse(String opcRequestId, String opcNextPage, List<OdaInstanceSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<OdaInstanceSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<OdaInstanceSummary> items;

        public Builder copy(ListOdaInstancesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<OdaInstanceSummary> items) {
            this.items = items;
            return this;
        }

        public ListOdaInstancesResponse build() {
            return new ListOdaInstancesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListOdaInstancesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

