/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ons.NotificationControlPlaneAsync;
import com.oracle.bmc.ons.internal.http.ChangeTopicCompartmentConverter;
import com.oracle.bmc.ons.internal.http.CreateTopicConverter;
import com.oracle.bmc.ons.internal.http.DeleteTopicConverter;
import com.oracle.bmc.ons.internal.http.GetTopicConverter;
import com.oracle.bmc.ons.internal.http.ListTopicsConverter;
import com.oracle.bmc.ons.internal.http.UpdateTopicConverter;
import com.oracle.bmc.ons.requests.ChangeTopicCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateTopicRequest;
import com.oracle.bmc.ons.requests.DeleteTopicRequest;
import com.oracle.bmc.ons.requests.GetTopicRequest;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.requests.UpdateTopicRequest;
import com.oracle.bmc.ons.responses.ChangeTopicCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateTopicResponse;
import com.oracle.bmc.ons.responses.DeleteTopicResponse;
import com.oracle.bmc.ons.responses.GetTopicResponse;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.ons.responses.UpdateTopicResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationControlPlaneAsyncClient
implements NotificationControlPlaneAsync {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationControlPlaneAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONCONTROLPLANE").serviceEndpointPrefix("notifications").serviceEndpointTemplate("https://notification.{region}.oraclecloud.com").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeTopicCompartmentResponse> changeTopicCompartment(ChangeTopicCompartmentRequest request, AsyncHandler<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse> handler) {
        LOG.trace("Called async changeTopicCompartment");
        final ChangeTopicCompartmentRequest interceptedRequest = ChangeTopicCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeTopicCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeTopicCompartmentResponse> transformer = ChangeTopicCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse> onSuccess = new SuccessConsumer<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeTopicCompartmentRequest> onError = new ErrorConsumer<ChangeTopicCompartmentRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.post(ib, interceptedRequest.getChangeTopicCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeTopicCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeTopicCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeTopicCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeTopicCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.post(ib, interceptedRequest.getChangeTopicCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeTopicCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateTopicResponse> createTopic(CreateTopicRequest request, AsyncHandler<CreateTopicRequest, CreateTopicResponse> handler) {
        LOG.trace("Called async createTopic");
        final CreateTopicRequest interceptedRequest = CreateTopicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateTopicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateTopicResponse> transformer = CreateTopicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateTopicRequest, CreateTopicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateTopicRequest, CreateTopicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateTopicRequest, CreateTopicResponse> onSuccess = new SuccessConsumer<CreateTopicRequest, CreateTopicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateTopicRequest> onError = new ErrorConsumer<CreateTopicRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.post(ib, interceptedRequest.getCreateTopicDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateTopicRequest, CreateTopicResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateTopicRequest, CreateTopicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateTopicRequest> onError = handler == null ? null : new ErrorConsumer<CreateTopicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateTopicDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateTopicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.post(ib, interceptedRequest.getCreateTopicDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateTopicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteTopicResponse> deleteTopic(DeleteTopicRequest request, AsyncHandler<DeleteTopicRequest, DeleteTopicResponse> handler) {
        LOG.trace("Called async deleteTopic");
        final DeleteTopicRequest interceptedRequest = DeleteTopicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteTopicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteTopicResponse> transformer = DeleteTopicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteTopicRequest, DeleteTopicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteTopicRequest, DeleteTopicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteTopicRequest, DeleteTopicResponse> onSuccess = new SuccessConsumer<DeleteTopicRequest, DeleteTopicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteTopicRequest> onError = new ErrorConsumer<DeleteTopicRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteTopicRequest, DeleteTopicResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteTopicRequest, DeleteTopicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteTopicRequest> onError = handler == null ? null : new ErrorConsumer<DeleteTopicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteTopicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteTopicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetTopicResponse> getTopic(GetTopicRequest request, AsyncHandler<GetTopicRequest, GetTopicResponse> handler) {
        LOG.trace("Called async getTopic");
        final GetTopicRequest interceptedRequest = GetTopicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetTopicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetTopicResponse> transformer = GetTopicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetTopicRequest, GetTopicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetTopicRequest, GetTopicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetTopicRequest, GetTopicResponse> onSuccess = new SuccessConsumer<GetTopicRequest, GetTopicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetTopicRequest> onError = new ErrorConsumer<GetTopicRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetTopicRequest, GetTopicResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetTopicRequest, GetTopicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetTopicRequest> onError = handler == null ? null : new ErrorConsumer<GetTopicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetTopicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetTopicResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTopicsResponse> listTopics(ListTopicsRequest request, AsyncHandler<ListTopicsRequest, ListTopicsResponse> handler) {
        LOG.trace("Called async listTopics");
        final ListTopicsRequest interceptedRequest = ListTopicsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTopicsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTopicsResponse> transformer = ListTopicsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTopicsRequest, ListTopicsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTopicsRequest, ListTopicsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTopicsRequest, ListTopicsResponse> onSuccess = new SuccessConsumer<ListTopicsRequest, ListTopicsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTopicsRequest> onError = new ErrorConsumer<ListTopicsRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTopicsRequest, ListTopicsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTopicsRequest, ListTopicsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTopicsRequest> onError = handler == null ? null : new ErrorConsumer<ListTopicsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTopicsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTopicsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateTopicResponse> updateTopic(UpdateTopicRequest request, AsyncHandler<UpdateTopicRequest, UpdateTopicResponse> handler) {
        LOG.trace("Called async updateTopic");
        final UpdateTopicRequest interceptedRequest = UpdateTopicConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateTopicConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateTopicResponse> transformer = UpdateTopicConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateTopicRequest, UpdateTopicResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateTopicRequest, UpdateTopicResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateTopicRequest, UpdateTopicResponse> onSuccess = new SuccessConsumer<UpdateTopicRequest, UpdateTopicResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateTopicRequest> onError = new ErrorConsumer<UpdateTopicRequest>(this, interceptedRequest);
                    NotificationControlPlaneAsyncClient.this.client.put(ib, interceptedRequest.getTopicAttributesDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateTopicRequest, UpdateTopicResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateTopicRequest, UpdateTopicResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateTopicRequest> onError = handler == null ? null : new ErrorConsumer<UpdateTopicRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getTopicAttributesDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateTopicResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationControlPlaneAsyncClient.this.client.put(ib, interceptedRequest.getTopicAttributesDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateTopicResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationControlPlaneAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public NotificationControlPlaneAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new NotificationControlPlaneAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

