/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.ons.NotificationControlPlane;
import com.oracle.bmc.ons.model.NotificationTopicSummary;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class NotificationControlPlanePaginators {
    private final NotificationControlPlane client;

    public Iterable<ListTopicsResponse> listTopicsResponseIterator(final ListTopicsRequest request) {
        return new ResponseIterable<ListTopicsRequest.Builder, ListTopicsRequest, ListTopicsResponse>(new Supplier<ListTopicsRequest.Builder>(){

            public ListTopicsRequest.Builder get() {
                return ListTopicsRequest.builder().copy(request);
            }
        }, new Function<ListTopicsResponse, String>(){

            public String apply(ListTopicsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTopicsRequest.Builder>, ListTopicsRequest>(){

            public ListTopicsRequest apply(RequestBuilderAndToken<ListTopicsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTopicsRequest, ListTopicsResponse>(){

            public ListTopicsResponse apply(ListTopicsRequest request) {
                return NotificationControlPlanePaginators.this.client.listTopics(request);
            }
        });
    }

    public Iterable<NotificationTopicSummary> listTopicsRecordIterator(final ListTopicsRequest request) {
        return new ResponseRecordIterable<ListTopicsRequest.Builder, ListTopicsRequest, ListTopicsResponse, NotificationTopicSummary>(new Supplier<ListTopicsRequest.Builder>(){

            public ListTopicsRequest.Builder get() {
                return ListTopicsRequest.builder().copy(request);
            }
        }, new Function<ListTopicsResponse, String>(){

            public String apply(ListTopicsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListTopicsRequest.Builder>, ListTopicsRequest>(){

            public ListTopicsRequest apply(RequestBuilderAndToken<ListTopicsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListTopicsRequest, ListTopicsResponse>(){

            public ListTopicsResponse apply(ListTopicsRequest request) {
                return NotificationControlPlanePaginators.this.client.listTopics(request);
            }
        }, new Function<ListTopicsResponse, List<NotificationTopicSummary>>(){

            public List<NotificationTopicSummary> apply(ListTopicsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public NotificationControlPlanePaginators(NotificationControlPlane client) {
        this.client = client;
    }
}

