/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ons.NotificationDataPlaneAsync;
import com.oracle.bmc.ons.internal.http.ChangeSubscriptionCompartmentConverter;
import com.oracle.bmc.ons.internal.http.CreateSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.DeleteSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetConfirmSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetUnsubscriptionConverter;
import com.oracle.bmc.ons.internal.http.ListSubscriptionsConverter;
import com.oracle.bmc.ons.internal.http.PublishMessageConverter;
import com.oracle.bmc.ons.internal.http.ResendSubscriptionConfirmationConverter;
import com.oracle.bmc.ons.internal.http.UpdateSubscriptionConverter;
import com.oracle.bmc.ons.requests.ChangeSubscriptionCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateSubscriptionRequest;
import com.oracle.bmc.ons.requests.DeleteSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.requests.ResendSubscriptionConfirmationRequest;
import com.oracle.bmc.ons.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ons.responses.ChangeSubscriptionCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateSubscriptionResponse;
import com.oracle.bmc.ons.responses.DeleteSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.ons.responses.ResendSubscriptionConfirmationResponse;
import com.oracle.bmc.ons.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDataPlaneAsyncClient
implements NotificationDataPlaneAsync {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataPlaneAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONDATAPLANE").serviceEndpointPrefix("notifications").serviceEndpointTemplate("https://notification.{region}.oraclecloud.com").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeSubscriptionCompartmentResponse> changeSubscriptionCompartment(ChangeSubscriptionCompartmentRequest request, AsyncHandler<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> handler) {
        LOG.trace("Called async changeSubscriptionCompartment");
        final ChangeSubscriptionCompartmentRequest interceptedRequest = ChangeSubscriptionCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeSubscriptionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeSubscriptionCompartmentResponse> transformer = ChangeSubscriptionCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> onSuccess = new SuccessConsumer<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeSubscriptionCompartmentRequest> onError = new ErrorConsumer<ChangeSubscriptionCompartmentRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getChangeSubscriptionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeSubscriptionCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeSubscriptionCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeSubscriptionCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeSubscriptionCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getChangeSubscriptionCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeSubscriptionCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest request, AsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResponse> handler) {
        LOG.trace("Called async createSubscription");
        final CreateSubscriptionRequest interceptedRequest = CreateSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateSubscriptionResponse> transformer = CreateSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateSubscriptionRequest, CreateSubscriptionResponse> onSuccess = new SuccessConsumer<CreateSubscriptionRequest, CreateSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateSubscriptionRequest> onError = new ErrorConsumer<CreateSubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getCreateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateSubscriptionRequest, CreateSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateSubscriptionRequest, CreateSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<CreateSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getCreateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteSubscriptionResponse> deleteSubscription(DeleteSubscriptionRequest request, AsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResponse> handler) {
        LOG.trace("Called async deleteSubscription");
        final DeleteSubscriptionRequest interceptedRequest = DeleteSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteSubscriptionResponse> transformer = DeleteSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteSubscriptionRequest, DeleteSubscriptionResponse> onSuccess = new SuccessConsumer<DeleteSubscriptionRequest, DeleteSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteSubscriptionRequest> onError = new ErrorConsumer<DeleteSubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteSubscriptionRequest, DeleteSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteSubscriptionRequest, DeleteSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<DeleteSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetConfirmSubscriptionResponse> getConfirmSubscription(GetConfirmSubscriptionRequest request, AsyncHandler<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> handler) {
        LOG.trace("Called async getConfirmSubscription");
        final GetConfirmSubscriptionRequest interceptedRequest = GetConfirmSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetConfirmSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetConfirmSubscriptionResponse> transformer = GetConfirmSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> onSuccess = new SuccessConsumer<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetConfirmSubscriptionRequest> onError = new ErrorConsumer<GetConfirmSubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetConfirmSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<GetConfirmSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetConfirmSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetConfirmSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request, AsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse> handler) {
        LOG.trace("Called async getSubscription");
        final GetSubscriptionRequest interceptedRequest = GetSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetSubscriptionResponse> transformer = GetSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetSubscriptionRequest, GetSubscriptionResponse> onSuccess = new SuccessConsumer<GetSubscriptionRequest, GetSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetSubscriptionRequest> onError = new ErrorConsumer<GetSubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetSubscriptionRequest, GetSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetSubscriptionRequest, GetSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<GetSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetSubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetUnsubscriptionResponse> getUnsubscription(GetUnsubscriptionRequest request, AsyncHandler<GetUnsubscriptionRequest, GetUnsubscriptionResponse> handler) {
        LOG.trace("Called async getUnsubscription");
        final GetUnsubscriptionRequest interceptedRequest = GetUnsubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetUnsubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetUnsubscriptionResponse> transformer = GetUnsubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetUnsubscriptionRequest, GetUnsubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetUnsubscriptionRequest, GetUnsubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetUnsubscriptionRequest, GetUnsubscriptionResponse> onSuccess = new SuccessConsumer<GetUnsubscriptionRequest, GetUnsubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetUnsubscriptionRequest> onError = new ErrorConsumer<GetUnsubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetUnsubscriptionRequest, GetUnsubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetUnsubscriptionRequest, GetUnsubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetUnsubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<GetUnsubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetUnsubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetUnsubscriptionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request, AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse> handler) {
        LOG.trace("Called async listSubscriptions");
        final ListSubscriptionsRequest interceptedRequest = ListSubscriptionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListSubscriptionsResponse> transformer = ListSubscriptionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListSubscriptionsRequest, ListSubscriptionsResponse> onSuccess = new SuccessConsumer<ListSubscriptionsRequest, ListSubscriptionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListSubscriptionsRequest> onError = new ErrorConsumer<ListSubscriptionsRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListSubscriptionsRequest, ListSubscriptionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListSubscriptionsRequest, ListSubscriptionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListSubscriptionsRequest> onError = handler == null ? null : new ErrorConsumer<ListSubscriptionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListSubscriptionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListSubscriptionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PublishMessageResponse> publishMessage(PublishMessageRequest request, AsyncHandler<PublishMessageRequest, PublishMessageResponse> handler) {
        LOG.trace("Called async publishMessage");
        final PublishMessageRequest interceptedRequest = PublishMessageConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PublishMessageConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PublishMessageResponse> transformer = PublishMessageConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PublishMessageRequest, PublishMessageResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PublishMessageRequest, PublishMessageResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PublishMessageRequest, PublishMessageResponse> onSuccess = new SuccessConsumer<PublishMessageRequest, PublishMessageResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PublishMessageRequest> onError = new ErrorConsumer<PublishMessageRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getMessageDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PublishMessageRequest, PublishMessageResponse> onSuccess = handler == null ? null : new SuccessConsumer<PublishMessageRequest, PublishMessageResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PublishMessageRequest> onError = handler == null ? null : new ErrorConsumer<PublishMessageRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getMessageDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PublishMessageResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest.getMessageDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PublishMessageResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ResendSubscriptionConfirmationResponse> resendSubscriptionConfirmation(ResendSubscriptionConfirmationRequest request, AsyncHandler<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> handler) {
        LOG.trace("Called async resendSubscriptionConfirmation");
        final ResendSubscriptionConfirmationRequest interceptedRequest = ResendSubscriptionConfirmationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ResendSubscriptionConfirmationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ResendSubscriptionConfirmationResponse> transformer = ResendSubscriptionConfirmationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> onSuccess = new SuccessConsumer<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ResendSubscriptionConfirmationRequest> onError = new ErrorConsumer<ResendSubscriptionConfirmationRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> onSuccess = handler == null ? null : new SuccessConsumer<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ResendSubscriptionConfirmationRequest> onError = handler == null ? null : new ErrorConsumer<ResendSubscriptionConfirmationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ResendSubscriptionConfirmationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ResendSubscriptionConfirmationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest request, AsyncHandler<UpdateSubscriptionRequest, UpdateSubscriptionResponse> handler) {
        LOG.trace("Called async updateSubscription");
        final UpdateSubscriptionRequest interceptedRequest = UpdateSubscriptionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateSubscriptionResponse> transformer = UpdateSubscriptionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateSubscriptionRequest, UpdateSubscriptionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateSubscriptionRequest, UpdateSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateSubscriptionRequest, UpdateSubscriptionResponse> onSuccess = new SuccessConsumer<UpdateSubscriptionRequest, UpdateSubscriptionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateSubscriptionRequest> onError = new ErrorConsumer<UpdateSubscriptionRequest>(this, interceptedRequest);
                    NotificationDataPlaneAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateSubscriptionRequest, UpdateSubscriptionResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateSubscriptionRequest, UpdateSubscriptionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateSubscriptionRequest> onError = handler == null ? null : new ErrorConsumer<UpdateSubscriptionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateSubscriptionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return NotificationDataPlaneAsyncClient.this.client.put(ib, interceptedRequest.getUpdateSubscriptionDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateSubscriptionResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationDataPlaneAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public NotificationDataPlaneAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new NotificationDataPlaneAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

