/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ons.NotificationDataPlane;
import com.oracle.bmc.ons.NotificationDataPlanePaginators;
import com.oracle.bmc.ons.NotificationDataPlaneWaiters;
import com.oracle.bmc.ons.internal.http.ChangeSubscriptionCompartmentConverter;
import com.oracle.bmc.ons.internal.http.CreateSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.DeleteSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetConfirmSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetUnsubscriptionConverter;
import com.oracle.bmc.ons.internal.http.ListSubscriptionsConverter;
import com.oracle.bmc.ons.internal.http.PublishMessageConverter;
import com.oracle.bmc.ons.internal.http.ResendSubscriptionConfirmationConverter;
import com.oracle.bmc.ons.internal.http.UpdateSubscriptionConverter;
import com.oracle.bmc.ons.requests.ChangeSubscriptionCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateSubscriptionRequest;
import com.oracle.bmc.ons.requests.DeleteSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.requests.ResendSubscriptionConfirmationRequest;
import com.oracle.bmc.ons.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ons.responses.ChangeSubscriptionCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateSubscriptionResponse;
import com.oracle.bmc.ons.responses.DeleteSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.ons.responses.ResendSubscriptionConfirmationResponse;
import com.oracle.bmc.ons.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDataPlaneClient
implements NotificationDataPlane {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataPlaneClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONDATAPLANE").serviceEndpointPrefix("notifications").serviceEndpointTemplate("https://notification.{region}.oraclecloud.com").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final NotificationDataPlaneWaiters waiters;
    private final NotificationDataPlanePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NotificationDataPlane-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new NotificationDataPlaneWaiters(executorService, this);
        this.paginators = new NotificationDataPlanePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeSubscriptionCompartmentResponse changeSubscriptionCompartment(ChangeSubscriptionCompartmentRequest request) {
        LOG.trace("Called changeSubscriptionCompartment");
        ChangeSubscriptionCompartmentRequest interceptedRequest = ChangeSubscriptionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSubscriptionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSubscriptionCompartmentResponse> transformer = ChangeSubscriptionCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeSubscriptionCompartmentDetails(), retriedRequest);
                return (ChangeSubscriptionCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest request) {
        LOG.trace("Called createSubscription");
        CreateSubscriptionRequest interceptedRequest = CreateSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSubscriptionResponse> transformer = CreateSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateSubscriptionDetails(), retriedRequest);
                return (CreateSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSubscriptionResponse deleteSubscription(DeleteSubscriptionRequest request) {
        LOG.trace("Called deleteSubscription");
        DeleteSubscriptionRequest interceptedRequest = DeleteSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSubscriptionResponse> transformer = DeleteSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConfirmSubscriptionResponse getConfirmSubscription(GetConfirmSubscriptionRequest request) {
        LOG.trace("Called getConfirmSubscription");
        GetConfirmSubscriptionRequest interceptedRequest = GetConfirmSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfirmSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfirmSubscriptionResponse> transformer = GetConfirmSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetConfirmSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSubscriptionResponse getSubscription(GetSubscriptionRequest request) {
        LOG.trace("Called getSubscription");
        GetSubscriptionRequest interceptedRequest = GetSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSubscriptionResponse> transformer = GetSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetUnsubscriptionResponse getUnsubscription(GetUnsubscriptionRequest request) {
        LOG.trace("Called getUnsubscription");
        GetUnsubscriptionRequest interceptedRequest = GetUnsubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUnsubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUnsubscriptionResponse> transformer = GetUnsubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetUnsubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
        LOG.trace("Called listSubscriptions");
        ListSubscriptionsRequest interceptedRequest = ListSubscriptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSubscriptionsResponse> transformer = ListSubscriptionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListSubscriptionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PublishMessageResponse publishMessage(PublishMessageRequest request) {
        LOG.trace("Called publishMessage");
        PublishMessageRequest interceptedRequest = PublishMessageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PublishMessageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PublishMessageResponse> transformer = PublishMessageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getMessageDetails(), retriedRequest);
                return (PublishMessageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResendSubscriptionConfirmationResponse resendSubscriptionConfirmation(ResendSubscriptionConfirmationRequest request) {
        LOG.trace("Called resendSubscriptionConfirmation");
        ResendSubscriptionConfirmationRequest interceptedRequest = ResendSubscriptionConfirmationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResendSubscriptionConfirmationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ResendSubscriptionConfirmationResponse> transformer = ResendSubscriptionConfirmationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (ResendSubscriptionConfirmationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest request) {
        LOG.trace("Called updateSubscription");
        UpdateSubscriptionRequest interceptedRequest = UpdateSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSubscriptionResponse> transformer = UpdateSubscriptionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateSubscriptionDetails(), retriedRequest);
                return (UpdateSubscriptionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public NotificationDataPlaneWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public NotificationDataPlanePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationDataPlaneClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public NotificationDataPlaneClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new NotificationDataPlaneClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

