/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.ons.model.NotificationTopic;
import com.oracle.bmc.ons.requests.GetTopicRequest;
import com.oracle.bmc.ons.responses.GetTopicResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTopicConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTopicConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTopicRequest interceptRequest(GetTopicRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTopicRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("topics").path(HttpUtils.encodePathSegment(request.getTopicId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetTopicResponse> fromResponse() {
        Function<Response, GetTopicResponse> transformer = new Function<Response, GetTopicResponse>(){

            public GetTopicResponse apply(Response rawResponse) {
                Optional<List<String>> etagHeader;
                LOG.trace("Transform function invoked for GetTopicResponse");
                Function<Response, WithHeaders<NotificationTopic>> responseFn = RESPONSE_CONVERSION_FACTORY.create(NotificationTopic.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetTopicResponse.Builder builder = GetTopicResponse.builder();
                builder.notificationTopic((NotificationTopic)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((etagHeader = HeaderUtils.get(headers, "etag")).isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                GetTopicResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

