/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUnsubscriptionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetUnsubscriptionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetUnsubscriptionRequest interceptRequest(GetUnsubscriptionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetUnsubscriptionRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getToken(), (String)"token is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getProtocol(), (String)"protocol is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("subscriptions").path(HttpUtils.encodePathSegment(request.getId())).path("unsubscription");
        target = target.queryParam("token", HttpUtils.attemptEncodeQueryParam(request.getToken()));
        target = target.queryParam("protocol", HttpUtils.attemptEncodeQueryParam(request.getProtocol()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetUnsubscriptionResponse> fromResponse() {
        Function<Response, GetUnsubscriptionResponse> transformer = new Function<Response, GetUnsubscriptionResponse>(){

            public GetUnsubscriptionResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetUnsubscriptionResponse");
                Function<Response, WithHeaders<String>> responseFn = RESPONSE_CONVERSION_FACTORY.create(String.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetUnsubscriptionResponse.Builder builder = GetUnsubscriptionResponse.builder();
                builder.value((String)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetUnsubscriptionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

