/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.ons.model.CreateTopicDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateTopicRequest
extends BmcRequest {
    private CreateTopicDetails createTopicDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"createTopicDetails", "opcRetryToken", "opcRequestId"})
    CreateTopicRequest(CreateTopicDetails createTopicDetails, String opcRetryToken, String opcRequestId) {
        this.createTopicDetails = createTopicDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateTopicDetails getCreateTopicDetails() {
        return this.createTopicDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateTopicDetails createTopicDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTopicRequest o) {
            this.createTopicDetails(o.getCreateTopicDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTopicRequest build() {
            CreateTopicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createTopicDetails(CreateTopicDetails createTopicDetails) {
            this.createTopicDetails = createTopicDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateTopicRequest buildWithoutInvocationCallback() {
            return new CreateTopicRequest(this.createTopicDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateTopicRequest.Builder(createTopicDetails=" + this.createTopicDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

