/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetUnsubscriptionRequest
extends BmcRequest {
    private String id;
    private String token;
    private String protocol;
    private String opcRequestId;

    @ConstructorProperties(value={"id", "token", "protocol", "opcRequestId"})
    GetUnsubscriptionRequest(String id, String token, String protocol, String opcRequestId) {
        this.id = id;
        this.token = token;
        this.protocol = protocol;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String id;
        private String token;
        private String protocol;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetUnsubscriptionRequest o) {
            this.id(o.getId());
            this.token(o.getToken());
            this.protocol(o.getProtocol());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetUnsubscriptionRequest build() {
            GetUnsubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetUnsubscriptionRequest buildWithoutInvocationCallback() {
            return new GetUnsubscriptionRequest(this.id, this.token, this.protocol, this.opcRequestId);
        }

        public String toString() {
            return "GetUnsubscriptionRequest.Builder(id=" + this.id + ", token=" + this.token + ", protocol=" + this.protocol + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

