/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.ons.model.UpdateSubscriptionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateSubscriptionRequest
extends BmcRequest {
    private String subscriptionId;
    private UpdateSubscriptionDetails updateSubscriptionDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"subscriptionId", "updateSubscriptionDetails", "opcRequestId", "ifMatch"})
    UpdateSubscriptionRequest(String subscriptionId, UpdateSubscriptionDetails updateSubscriptionDetails, String opcRequestId, String ifMatch) {
        this.subscriptionId = subscriptionId;
        this.updateSubscriptionDetails = updateSubscriptionDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public UpdateSubscriptionDetails getUpdateSubscriptionDetails() {
        return this.updateSubscriptionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String subscriptionId;
        private UpdateSubscriptionDetails updateSubscriptionDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubscriptionRequest o) {
            this.subscriptionId(o.getSubscriptionId());
            this.updateSubscriptionDetails(o.getUpdateSubscriptionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubscriptionRequest build() {
            UpdateSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder updateSubscriptionDetails(UpdateSubscriptionDetails updateSubscriptionDetails) {
            this.updateSubscriptionDetails = updateSubscriptionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateSubscriptionRequest buildWithoutInvocationCallback() {
            return new UpdateSubscriptionRequest(this.subscriptionId, this.updateSubscriptionDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateSubscriptionRequest.Builder(subscriptionId=" + this.subscriptionId + ", updateSubscriptionDetails=" + this.updateSubscriptionDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

