/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.Subscription;
import java.beans.ConstructorProperties;

public class CreateSubscriptionResponse {
    private String opcRequestId;
    private String etag;
    private Subscription subscription;

    @ConstructorProperties(value={"opcRequestId", "etag", "subscription"})
    CreateSubscriptionResponse(String opcRequestId, String etag, Subscription subscription) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.subscription = subscription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Subscription subscription;

        public Builder copy(CreateSubscriptionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.subscription(o.getSubscription());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public CreateSubscriptionResponse build() {
            return new CreateSubscriptionResponse(this.opcRequestId, this.etag, this.subscription);
        }

        public String toString() {
            return "CreateSubscriptionResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", subscription=" + this.subscription + ")";
        }
    }
}

