/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.NotificationTopic;
import java.beans.ConstructorProperties;

public class CreateTopicResponse {
    private String opcRequestId;
    private String etag;
    private NotificationTopic notificationTopic;

    @ConstructorProperties(value={"opcRequestId", "etag", "notificationTopic"})
    CreateTopicResponse(String opcRequestId, String etag, NotificationTopic notificationTopic) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.notificationTopic = notificationTopic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public NotificationTopic getNotificationTopic() {
        return this.notificationTopic;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private NotificationTopic notificationTopic;

        public Builder copy(CreateTopicResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.notificationTopic(o.getNotificationTopic());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder notificationTopic(NotificationTopic notificationTopic) {
            this.notificationTopic = notificationTopic;
            return this;
        }

        public CreateTopicResponse build() {
            return new CreateTopicResponse(this.opcRequestId, this.etag, this.notificationTopic);
        }

        public String toString() {
            return "CreateTopicResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", notificationTopic=" + this.notificationTopic + ")";
        }
    }
}

