/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.ConfirmationResult;
import java.beans.ConstructorProperties;

public class GetConfirmSubscriptionResponse {
    private String opcRequestId;
    private String etag;
    private ConfirmationResult confirmationResult;

    @ConstructorProperties(value={"opcRequestId", "etag", "confirmationResult"})
    GetConfirmSubscriptionResponse(String opcRequestId, String etag, ConfirmationResult confirmationResult) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.confirmationResult = confirmationResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ConfirmationResult getConfirmationResult() {
        return this.confirmationResult;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private ConfirmationResult confirmationResult;

        public Builder copy(GetConfirmSubscriptionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.confirmationResult(o.getConfirmationResult());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder confirmationResult(ConfirmationResult confirmationResult) {
            this.confirmationResult = confirmationResult;
            return this;
        }

        public GetConfirmSubscriptionResponse build() {
            return new GetConfirmSubscriptionResponse(this.opcRequestId, this.etag, this.confirmationResult);
        }

        public String toString() {
            return "GetConfirmSubscriptionResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", confirmationResult=" + this.confirmationResult + ")";
        }
    }
}

