/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.SubscriptionSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListSubscriptionsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<SubscriptionSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListSubscriptionsResponse(String opcNextPage, String opcRequestId, List<SubscriptionSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<SubscriptionSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<SubscriptionSummary> items;

        public Builder copy(ListSubscriptionsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<SubscriptionSummary> items) {
            this.items = items;
            return this;
        }

        public ListSubscriptionsResponse build() {
            return new ListSubscriptionsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListSubscriptionsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

