/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.NotificationTopicSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListTopicsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<NotificationTopicSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListTopicsResponse(String opcNextPage, String opcRequestId, List<NotificationTopicSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<NotificationTopicSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<NotificationTopicSummary> items;

        public Builder copy(ListTopicsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<NotificationTopicSummary> items) {
            this.items = items;
            return this;
        }

        public ListTopicsResponse build() {
            return new ListTopicsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListTopicsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

