/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.PublishResult;
import java.beans.ConstructorProperties;

public class PublishMessageResponse {
    private String opcRequestId;
    private PublishResult publishResult;

    @ConstructorProperties(value={"opcRequestId", "publishResult"})
    PublishMessageResponse(String opcRequestId, PublishResult publishResult) {
        this.opcRequestId = opcRequestId;
        this.publishResult = publishResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PublishResult getPublishResult() {
        return this.publishResult;
    }

    public static class Builder {
        private String opcRequestId;
        private PublishResult publishResult;

        public Builder copy(PublishMessageResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.publishResult(o.getPublishResult());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder publishResult(PublishResult publishResult) {
            this.publishResult = publishResult;
            return this;
        }

        public PublishMessageResponse build() {
            return new PublishMessageResponse(this.opcRequestId, this.publishResult);
        }

        public String toString() {
            return "PublishMessageResponse.Builder(opcRequestId=" + this.opcRequestId + ", publishResult=" + this.publishResult + ")";
        }
    }
}

