/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.Subscription;
import java.beans.ConstructorProperties;

public class ResendSubscriptionConfirmationResponse {
    private String opcRequestId;
    private Subscription subscription;

    @ConstructorProperties(value={"opcRequestId", "subscription"})
    ResendSubscriptionConfirmationResponse(String opcRequestId, Subscription subscription) {
        this.opcRequestId = opcRequestId;
        this.subscription = subscription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public static class Builder {
        private String opcRequestId;
        private Subscription subscription;

        public Builder copy(ResendSubscriptionConfirmationResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.subscription(o.getSubscription());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public ResendSubscriptionConfirmationResponse build() {
            return new ResendSubscriptionConfirmationResponse(this.opcRequestId, this.subscription);
        }

        public String toString() {
            return "ResendSubscriptionConfirmationResponse.Builder(opcRequestId=" + this.opcRequestId + ", subscription=" + this.subscription + ")";
        }
    }
}

