/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.UpdateSubscriptionDetails;
import java.beans.ConstructorProperties;

public class UpdateSubscriptionResponse {
    private String opcRequestId;
    private String etag;
    private UpdateSubscriptionDetails updateSubscriptionDetails;

    @ConstructorProperties(value={"opcRequestId", "etag", "updateSubscriptionDetails"})
    UpdateSubscriptionResponse(String opcRequestId, String etag, UpdateSubscriptionDetails updateSubscriptionDetails) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.updateSubscriptionDetails = updateSubscriptionDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public UpdateSubscriptionDetails getUpdateSubscriptionDetails() {
        return this.updateSubscriptionDetails;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private UpdateSubscriptionDetails updateSubscriptionDetails;

        public Builder copy(UpdateSubscriptionResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.updateSubscriptionDetails(o.getUpdateSubscriptionDetails());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder updateSubscriptionDetails(UpdateSubscriptionDetails updateSubscriptionDetails) {
            this.updateSubscriptionDetails = updateSubscriptionDetails;
            return this;
        }

        public UpdateSubscriptionResponse build() {
            return new UpdateSubscriptionResponse(this.opcRequestId, this.etag, this.updateSubscriptionDetails);
        }

        public String toString() {
            return "UpdateSubscriptionResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", updateSubscriptionDetails=" + this.updateSubscriptionDetails + ")";
        }
    }
}

