/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.resourcemanager.ResourceManagerAsync;
import com.oracle.bmc.resourcemanager.internal.http.CancelJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeStackCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsContentConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListJobsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStacksConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTerraformVersionsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateStackConverter;
import com.oracle.bmc.resourcemanager.requests.CancelJobRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.CreateJobRequest;
import com.oracle.bmc.resourcemanager.requests.CreateStackRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateJobRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateStackRequest;
import com.oracle.bmc.resourcemanager.responses.CancelJobResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.CreateJobResponse;
import com.oracle.bmc.resourcemanager.responses.CreateStackResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateJobResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateStackResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerAsyncClient
implements ResourceManagerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCEMANAGER").serviceEndpointPrefix("resourcemanager").serviceEndpointTemplate("https://resourcemanager.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceManagerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceManagerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelJobResponse> cancelJob(CancelJobRequest request, AsyncHandler<CancelJobRequest, CancelJobResponse> handler) {
        LOG.trace("Called async cancelJob");
        final CancelJobRequest interceptedRequest = CancelJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CancelJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CancelJobResponse> transformer = CancelJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CancelJobRequest, CancelJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CancelJobRequest, CancelJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CancelJobRequest, CancelJobResponse> onSuccess = new SuccessConsumer<CancelJobRequest, CancelJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CancelJobRequest> onError = new ErrorConsumer<CancelJobRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CancelJobRequest, CancelJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<CancelJobRequest, CancelJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CancelJobRequest> onError = handler == null ? null : new ErrorConsumer<CancelJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CancelJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CancelJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeStackCompartmentResponse> changeStackCompartment(ChangeStackCompartmentRequest request, AsyncHandler<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> handler) {
        LOG.trace("Called async changeStackCompartment");
        final ChangeStackCompartmentRequest interceptedRequest = ChangeStackCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeStackCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeStackCompartmentResponse> transformer = ChangeStackCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> onSuccess = new SuccessConsumer<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeStackCompartmentRequest> onError = new ErrorConsumer<ChangeStackCompartmentRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getChangeStackCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeStackCompartmentRequest, ChangeStackCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeStackCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeStackCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeStackCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeStackCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getChangeStackCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeStackCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        LOG.trace("Called async createJob");
        final CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateJobRequest, CreateJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateJobRequest, CreateJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateJobRequest, CreateJobResponse> onSuccess = new SuccessConsumer<CreateJobRequest, CreateJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateJobRequest> onError = new ErrorConsumer<CreateJobRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getCreateJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateJobRequest, CreateJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateJobRequest, CreateJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateJobRequest> onError = handler == null ? null : new ErrorConsumer<CreateJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getCreateJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateStackResponse> createStack(CreateStackRequest request, AsyncHandler<CreateStackRequest, CreateStackResponse> handler) {
        LOG.trace("Called async createStack");
        final CreateStackRequest interceptedRequest = CreateStackConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateStackConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateStackResponse> transformer = CreateStackConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateStackRequest, CreateStackResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateStackRequest, CreateStackResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateStackRequest, CreateStackResponse> onSuccess = new SuccessConsumer<CreateStackRequest, CreateStackResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateStackRequest> onError = new ErrorConsumer<CreateStackRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getCreateStackDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateStackRequest, CreateStackResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateStackRequest, CreateStackResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateStackRequest> onError = handler == null ? null : new ErrorConsumer<CreateStackRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateStackDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateStackResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.post(ib, interceptedRequest.getCreateStackDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateStackResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteStackResponse> deleteStack(DeleteStackRequest request, AsyncHandler<DeleteStackRequest, DeleteStackResponse> handler) {
        LOG.trace("Called async deleteStack");
        final DeleteStackRequest interceptedRequest = DeleteStackConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteStackConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteStackResponse> transformer = DeleteStackConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteStackRequest, DeleteStackResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteStackRequest, DeleteStackResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteStackRequest, DeleteStackResponse> onSuccess = new SuccessConsumer<DeleteStackRequest, DeleteStackResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteStackRequest> onError = new ErrorConsumer<DeleteStackRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteStackRequest, DeleteStackResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteStackRequest, DeleteStackResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteStackRequest> onError = handler == null ? null : new ErrorConsumer<DeleteStackRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteStackResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteStackResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        LOG.trace("Called async getJob");
        final GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJobRequest, GetJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJobRequest, GetJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJobRequest, GetJobResponse> onSuccess = new SuccessConsumer<GetJobRequest, GetJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJobRequest> onError = new ErrorConsumer<GetJobRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJobRequest, GetJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJobRequest, GetJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJobRequest> onError = handler == null ? null : new ErrorConsumer<GetJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJobLogsResponse> getJobLogs(GetJobLogsRequest request, AsyncHandler<GetJobLogsRequest, GetJobLogsResponse> handler) {
        LOG.trace("Called async getJobLogs");
        final GetJobLogsRequest interceptedRequest = GetJobLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJobLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJobLogsResponse> transformer = GetJobLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJobLogsRequest, GetJobLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJobLogsRequest, GetJobLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJobLogsRequest, GetJobLogsResponse> onSuccess = new SuccessConsumer<GetJobLogsRequest, GetJobLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJobLogsRequest> onError = new ErrorConsumer<GetJobLogsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJobLogsRequest, GetJobLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJobLogsRequest, GetJobLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJobLogsRequest> onError = handler == null ? null : new ErrorConsumer<GetJobLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJobLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJobLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJobLogsContentResponse> getJobLogsContent(GetJobLogsContentRequest request, AsyncHandler<GetJobLogsContentRequest, GetJobLogsContentResponse> handler) {
        LOG.trace("Called async getJobLogsContent");
        final GetJobLogsContentRequest interceptedRequest = GetJobLogsContentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJobLogsContentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJobLogsContentResponse> transformer = GetJobLogsContentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJobLogsContentRequest, GetJobLogsContentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJobLogsContentRequest, GetJobLogsContentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJobLogsContentRequest, GetJobLogsContentResponse> onSuccess = new SuccessConsumer<GetJobLogsContentRequest, GetJobLogsContentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJobLogsContentRequest> onError = new ErrorConsumer<GetJobLogsContentRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJobLogsContentRequest, GetJobLogsContentResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJobLogsContentRequest, GetJobLogsContentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJobLogsContentRequest> onError = handler == null ? null : new ErrorConsumer<GetJobLogsContentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJobLogsContentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJobLogsContentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJobTfConfigResponse> getJobTfConfig(GetJobTfConfigRequest request, AsyncHandler<GetJobTfConfigRequest, GetJobTfConfigResponse> handler) {
        LOG.trace("Called async getJobTfConfig");
        final GetJobTfConfigRequest interceptedRequest = GetJobTfConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJobTfConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJobTfConfigResponse> transformer = GetJobTfConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJobTfConfigRequest, GetJobTfConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJobTfConfigRequest, GetJobTfConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJobTfConfigRequest, GetJobTfConfigResponse> onSuccess = new SuccessConsumer<GetJobTfConfigRequest, GetJobTfConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJobTfConfigRequest> onError = new ErrorConsumer<GetJobTfConfigRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJobTfConfigRequest, GetJobTfConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJobTfConfigRequest, GetJobTfConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJobTfConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetJobTfConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJobTfConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJobTfConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetJobTfStateResponse> getJobTfState(GetJobTfStateRequest request, AsyncHandler<GetJobTfStateRequest, GetJobTfStateResponse> handler) {
        LOG.trace("Called async getJobTfState");
        final GetJobTfStateRequest interceptedRequest = GetJobTfStateConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetJobTfStateConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetJobTfStateResponse> transformer = GetJobTfStateConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetJobTfStateRequest, GetJobTfStateResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetJobTfStateRequest, GetJobTfStateResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetJobTfStateRequest, GetJobTfStateResponse> onSuccess = new SuccessConsumer<GetJobTfStateRequest, GetJobTfStateResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetJobTfStateRequest> onError = new ErrorConsumer<GetJobTfStateRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetJobTfStateRequest, GetJobTfStateResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetJobTfStateRequest, GetJobTfStateResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetJobTfStateRequest> onError = handler == null ? null : new ErrorConsumer<GetJobTfStateRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetJobTfStateResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetJobTfStateResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetStackResponse> getStack(GetStackRequest request, AsyncHandler<GetStackRequest, GetStackResponse> handler) {
        LOG.trace("Called async getStack");
        final GetStackRequest interceptedRequest = GetStackConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetStackConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetStackResponse> transformer = GetStackConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetStackRequest, GetStackResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetStackRequest, GetStackResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetStackRequest, GetStackResponse> onSuccess = new SuccessConsumer<GetStackRequest, GetStackResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetStackRequest> onError = new ErrorConsumer<GetStackRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetStackRequest, GetStackResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetStackRequest, GetStackResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetStackRequest> onError = handler == null ? null : new ErrorConsumer<GetStackRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetStackResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetStackResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetStackTfConfigResponse> getStackTfConfig(GetStackTfConfigRequest request, AsyncHandler<GetStackTfConfigRequest, GetStackTfConfigResponse> handler) {
        LOG.trace("Called async getStackTfConfig");
        final GetStackTfConfigRequest interceptedRequest = GetStackTfConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetStackTfConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetStackTfConfigResponse> transformer = GetStackTfConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetStackTfConfigRequest, GetStackTfConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetStackTfConfigRequest, GetStackTfConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetStackTfConfigRequest, GetStackTfConfigResponse> onSuccess = new SuccessConsumer<GetStackTfConfigRequest, GetStackTfConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetStackTfConfigRequest> onError = new ErrorConsumer<GetStackTfConfigRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetStackTfConfigRequest, GetStackTfConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetStackTfConfigRequest, GetStackTfConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetStackTfConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetStackTfConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetStackTfConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetStackTfConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        LOG.trace("Called async listJobs");
        final ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListJobsRequest, ListJobsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListJobsRequest, ListJobsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListJobsRequest, ListJobsResponse> onSuccess = new SuccessConsumer<ListJobsRequest, ListJobsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListJobsRequest> onError = new ErrorConsumer<ListJobsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListJobsRequest, ListJobsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListJobsRequest, ListJobsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListJobsRequest> onError = handler == null ? null : new ErrorConsumer<ListJobsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListJobsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListJobsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListStacksResponse> listStacks(ListStacksRequest request, AsyncHandler<ListStacksRequest, ListStacksResponse> handler) {
        LOG.trace("Called async listStacks");
        final ListStacksRequest interceptedRequest = ListStacksConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListStacksConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListStacksResponse> transformer = ListStacksConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListStacksRequest, ListStacksResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListStacksRequest, ListStacksResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListStacksRequest, ListStacksResponse> onSuccess = new SuccessConsumer<ListStacksRequest, ListStacksResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListStacksRequest> onError = new ErrorConsumer<ListStacksRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListStacksRequest, ListStacksResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListStacksRequest, ListStacksResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListStacksRequest> onError = handler == null ? null : new ErrorConsumer<ListStacksRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListStacksResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListStacksResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListTerraformVersionsResponse> listTerraformVersions(ListTerraformVersionsRequest request, AsyncHandler<ListTerraformVersionsRequest, ListTerraformVersionsResponse> handler) {
        LOG.trace("Called async listTerraformVersions");
        final ListTerraformVersionsRequest interceptedRequest = ListTerraformVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListTerraformVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListTerraformVersionsResponse> transformer = ListTerraformVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListTerraformVersionsRequest, ListTerraformVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListTerraformVersionsRequest, ListTerraformVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListTerraformVersionsRequest, ListTerraformVersionsResponse> onSuccess = new SuccessConsumer<ListTerraformVersionsRequest, ListTerraformVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListTerraformVersionsRequest> onError = new ErrorConsumer<ListTerraformVersionsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListTerraformVersionsRequest, ListTerraformVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListTerraformVersionsRequest, ListTerraformVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListTerraformVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListTerraformVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListTerraformVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListTerraformVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestErrorsRequest> onError = new ErrorConsumer<ListWorkRequestErrorsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestErrorsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestErrorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestLogsRequest> onError = new ErrorConsumer<ListWorkRequestLogsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        LOG.trace("Called async updateJob");
        final UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateJobRequest, UpdateJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateJobRequest, UpdateJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateJobRequest, UpdateJobResponse> onSuccess = new SuccessConsumer<UpdateJobRequest, UpdateJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateJobRequest> onError = new ErrorConsumer<UpdateJobRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateJobRequest, UpdateJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateJobRequest, UpdateJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateJobRequest> onError = handler == null ? null : new ErrorConsumer<UpdateJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateStackResponse> updateStack(UpdateStackRequest request, AsyncHandler<UpdateStackRequest, UpdateStackResponse> handler) {
        LOG.trace("Called async updateStack");
        final UpdateStackRequest interceptedRequest = UpdateStackConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateStackConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateStackResponse> transformer = UpdateStackConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateStackRequest, UpdateStackResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateStackRequest, UpdateStackResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateStackRequest, UpdateStackResponse> onSuccess = new SuccessConsumer<UpdateStackRequest, UpdateStackResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateStackRequest> onError = new ErrorConsumer<UpdateStackRequest>(this, interceptedRequest);
                    ResourceManagerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStackDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateStackRequest, UpdateStackResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateStackRequest, UpdateStackResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateStackRequest> onError = handler == null ? null : new ErrorConsumer<UpdateStackRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateStackDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateStackResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ResourceManagerAsyncClient.this.client.put(ib, interceptedRequest.getUpdateStackDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateStackResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceManagerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ResourceManagerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ResourceManagerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

