/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.ResourceManagerPaginators;
import com.oracle.bmc.resourcemanager.ResourceManagerWaiters;
import com.oracle.bmc.resourcemanager.internal.http.CancelJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeStackCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsContentConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListJobsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStacksConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTerraformVersionsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateStackConverter;
import com.oracle.bmc.resourcemanager.requests.CancelJobRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.CreateJobRequest;
import com.oracle.bmc.resourcemanager.requests.CreateStackRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateJobRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateStackRequest;
import com.oracle.bmc.resourcemanager.responses.CancelJobResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.CreateJobResponse;
import com.oracle.bmc.resourcemanager.responses.CreateStackResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateJobResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateStackResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerClient
implements ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCEMANAGER").serviceEndpointPrefix("resourcemanager").serviceEndpointTemplate("https://resourcemanager.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ResourceManagerWaiters waiters;
    private final ResourceManagerPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ResourceManager-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ResourceManagerWaiters(executorService, this);
        this.paginators = new ResourceManagerPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest request) {
        LOG.trace("Called cancelJob");
        CancelJobRequest interceptedRequest = CancelJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelJobResponse> transformer = CancelJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (CancelJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeStackCompartmentResponse changeStackCompartment(ChangeStackCompartmentRequest request) {
        LOG.trace("Called changeStackCompartment");
        ChangeStackCompartmentRequest interceptedRequest = ChangeStackCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStackCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStackCompartmentResponse> transformer = ChangeStackCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeStackCompartmentDetails(), retriedRequest);
                return (ChangeStackCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateJobDetails(), retriedRequest);
                return (CreateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest request) {
        LOG.trace("Called createStack");
        CreateStackRequest interceptedRequest = CreateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStackResponse> transformer = CreateStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateStackDetails(), retriedRequest);
                return (CreateStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest request) {
        LOG.trace("Called deleteStack");
        DeleteStackRequest interceptedRequest = DeleteStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStackResponse> transformer = DeleteStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobLogsResponse getJobLogs(GetJobLogsRequest request) {
        LOG.trace("Called getJobLogs");
        GetJobLogsRequest interceptedRequest = GetJobLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsResponse> transformer = GetJobLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetJobLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobLogsContentResponse getJobLogsContent(GetJobLogsContentRequest request) {
        LOG.trace("Called getJobLogsContent");
        GetJobLogsContentRequest interceptedRequest = GetJobLogsContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsContentResponse> transformer = GetJobLogsContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetJobLogsContentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobTfConfigResponse getJobTfConfig(GetJobTfConfigRequest request) {
        LOG.trace("Called getJobTfConfig");
        GetJobTfConfigRequest interceptedRequest = GetJobTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfConfigResponse> transformer = GetJobTfConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetJobTfConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobTfStateResponse getJobTfState(GetJobTfStateRequest request) {
        LOG.trace("Called getJobTfState");
        GetJobTfStateRequest interceptedRequest = GetJobTfStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfStateResponse> transformer = GetJobTfStateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetJobTfStateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStackResponse getStack(GetStackRequest request) {
        LOG.trace("Called getStack");
        GetStackRequest interceptedRequest = GetStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackResponse> transformer = GetStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStackTfConfigResponse getStackTfConfig(GetStackTfConfigRequest request) {
        LOG.trace("Called getStackTfConfig");
        GetStackTfConfigRequest interceptedRequest = GetStackTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackTfConfigResponse> transformer = GetStackTfConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetStackTfConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListJobsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest request) {
        LOG.trace("Called listStacks");
        ListStacksRequest interceptedRequest = ListStacksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStacksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStacksResponse> transformer = ListStacksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListStacksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTerraformVersionsResponse listTerraformVersions(ListTerraformVersionsRequest request) {
        LOG.trace("Called listTerraformVersions");
        ListTerraformVersionsRequest interceptedRequest = ListTerraformVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTerraformVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTerraformVersionsResponse> transformer = ListTerraformVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListTerraformVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        LOG.trace("Called updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateJobDetails(), retriedRequest);
                return (UpdateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest request) {
        LOG.trace("Called updateStack");
        UpdateStackRequest interceptedRequest = UpdateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStackResponse> transformer = UpdateStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateStackDetails(), retriedRequest);
                return (UpdateStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResourceManagerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ResourceManagerPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceManagerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ResourceManagerClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ResourceManagerClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

