/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.model.JobSummary;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.resourcemanager.model.StackSummary;
import com.oracle.bmc.resourcemanager.model.WorkRequestError;
import com.oracle.bmc.resourcemanager.model.WorkRequestLogEntry;
import com.oracle.bmc.resourcemanager.model.WorkRequestSummary;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class ResourceManagerPaginators {
    private final ResourceManager client;

    public Iterable<GetJobLogsResponse> getJobLogsResponseIterator(final GetJobLogsRequest request) {
        return new ResponseIterable<GetJobLogsRequest.Builder, GetJobLogsRequest, GetJobLogsResponse>(new Supplier<GetJobLogsRequest.Builder>(){

            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, new Function<GetJobLogsResponse, String>(){

            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        });
    }

    public Iterable<LogEntry> getJobLogsRecordIterator(final GetJobLogsRequest request) {
        return new ResponseRecordIterable<GetJobLogsRequest.Builder, GetJobLogsRequest, GetJobLogsResponse, LogEntry>(new Supplier<GetJobLogsRequest.Builder>(){

            public GetJobLogsRequest.Builder get() {
                return GetJobLogsRequest.builder().copy(request);
            }
        }, new Function<GetJobLogsResponse, String>(){

            public String apply(GetJobLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<GetJobLogsRequest.Builder>, GetJobLogsRequest>(){

            public GetJobLogsRequest apply(RequestBuilderAndToken<GetJobLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<GetJobLogsRequest, GetJobLogsResponse>(){

            public GetJobLogsResponse apply(GetJobLogsRequest request) {
                return ResourceManagerPaginators.this.client.getJobLogs(request);
            }
        }, new Function<GetJobLogsResponse, List<LogEntry>>(){

            public List<LogEntry> apply(GetJobLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListJobsResponse> listJobsResponseIterator(final ListJobsRequest request) {
        return new ResponseIterable<ListJobsRequest.Builder, ListJobsRequest, ListJobsResponse>(new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        });
    }

    public Iterable<JobSummary> listJobsRecordIterator(final ListJobsRequest request) {
        return new ResponseRecordIterable<ListJobsRequest.Builder, ListJobsRequest, ListJobsResponse, JobSummary>(new Supplier<ListJobsRequest.Builder>(){

            public ListJobsRequest.Builder get() {
                return ListJobsRequest.builder().copy(request);
            }
        }, new Function<ListJobsResponse, String>(){

            public String apply(ListJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListJobsRequest.Builder>, ListJobsRequest>(){

            public ListJobsRequest apply(RequestBuilderAndToken<ListJobsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListJobsRequest, ListJobsResponse>(){

            public ListJobsResponse apply(ListJobsRequest request) {
                return ResourceManagerPaginators.this.client.listJobs(request);
            }
        }, new Function<ListJobsResponse, List<JobSummary>>(){

            public List<JobSummary> apply(ListJobsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListStacksResponse> listStacksResponseIterator(final ListStacksRequest request) {
        return new ResponseIterable<ListStacksRequest.Builder, ListStacksRequest, ListStacksResponse>(new Supplier<ListStacksRequest.Builder>(){

            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, new Function<ListStacksResponse, String>(){

            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListStacksRequest, ListStacksResponse>(){

            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        });
    }

    public Iterable<StackSummary> listStacksRecordIterator(final ListStacksRequest request) {
        return new ResponseRecordIterable<ListStacksRequest.Builder, ListStacksRequest, ListStacksResponse, StackSummary>(new Supplier<ListStacksRequest.Builder>(){

            public ListStacksRequest.Builder get() {
                return ListStacksRequest.builder().copy(request);
            }
        }, new Function<ListStacksResponse, String>(){

            public String apply(ListStacksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListStacksRequest.Builder>, ListStacksRequest>(){

            public ListStacksRequest apply(RequestBuilderAndToken<ListStacksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListStacksRequest, ListStacksResponse>(){

            public ListStacksResponse apply(ListStacksRequest request) {
                return ResourceManagerPaginators.this.client.listStacks(request);
            }
        }, new Function<ListStacksResponse, List<StackSummary>>(){

            public List<StackSummary> apply(ListStacksResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse, WorkRequestError>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestErrors(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse, WorkRequestLogEntry>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequestLogs(request);
            }
        }, new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequestSummary>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ResourceManagerPaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ResourceManagerPaginators(ResourceManager client) {
        this.client = client;
    }
}

