/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.model.Job;
import com.oracle.bmc.resourcemanager.model.Stack;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class ResourceManagerWaiters {
    private final ExecutorService executorService;
    private final ResourceManager client;

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, Job.LifecycleState ... targetStates) {
        final HashSet<Job.LifecycleState> targetStatesSet = new HashSet<Job.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetJobRequest, GetJobResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetJobRequest, GetJobResponse>(){

            public GetJobResponse apply(GetJobRequest request) {
                return ResourceManagerWaiters.this.client.getJob(request);
            }
        }, new Predicate<GetJobResponse>(){

            public boolean apply(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, Stack.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStack(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, Stack.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStack(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Stack.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStack(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetStackRequest, GetStackResponse> forStack(BmcGenericWaiter waiter, GetStackRequest request, Stack.LifecycleState ... targetStates) {
        final HashSet<Stack.LifecycleState> targetStatesSet = new HashSet<Stack.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetStackRequest, GetStackResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetStackRequest, GetStackResponse>(){

            public GetStackResponse apply(GetStackRequest request) {
                return ResourceManagerWaiters.this.client.getStack(request);
            }
        }, new Predicate<GetStackResponse>(){

            public boolean apply(GetStackResponse response) {
                return targetStatesSet.contains((Object)response.getStack().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Stack.LifecycleState.Deleted)), request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter(terminationStrategy, delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl<GetWorkRequestRequest, GetWorkRequestResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ResourceManagerWaiters.this.client.getWorkRequest(request);
            }
        }, new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public ResourceManagerWaiters(ExecutorService executorService, ResourceManager client) {
        this.executorService = executorService;
        this.client = client;
    }
}

